(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 3.0,
MathReader 3.0, or any compatible application. The data for the notebook 
starts with the line of stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[      5894,        172]*)
(*NotebookOutlinePosition[      6662,        199]*)
(*  CellTagsIndexPosition[      6618,        195]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell["Normas para entregar los ejercicios", "Subsection"],

Cell[TextData[{
  StyleBox["1",
    FontWeight->"Bold"],
  " ",
  StyleBox["Identificaci\[OAcute]n del cuaderno.",
    FontWeight->"Bold"],
  " Este cuaderno se llama \"evaluacion2.nb\". Debes renombrarlo. Para ello \
vas a File\[Rule] Save As... y al guardarlo (debes guardarlo en el \
escritorio) le pones tus apellidos y nombre terminado en 2 (en ese orden) \
todo seguido, en min\[UAcute]sculas y sin acentos. Por ejemplo, si te llamas \
Luis G\[OAcute]mez Ruiz debes llamar a tu archivo gomezruizluis2.nb\n",
  StyleBox["2 Comprobaci\[OAcute]n de comandos",
    FontWeight->"Bold"],
  ". Antes de entregar tu examen debes comprobar todos y cada uno de los \
comandos que has usado. Si alguno no funciona correctamente y no sabes \
corregirlo debes indicar claramente que el comando que has escrito no \
funciona correctamente. Si al ejecutar un comando se llena la pantalla de \
mensajes de error o se cuelga el ordenador, el ejercicio correspondiente ser\
\[AAcute] calificado con 0. \n",
  StyleBox["3 Borrar salidas y guardar",
    FontWeight->"Bold"],
  ". Cuando termines tu trabajo es muy importante que borres todas las \
salidas antes de guardar el cuaderno. Para ello vas a Kernel \[Rule] Delete \
all Output. \n",
  StyleBox["4 Entrega del examen",
    FontWeight->"Bold"],
  ". Entras en el SWAD (swad.ugr.es) vas a Asignatura\[Rule]An\[AAcute]lisis \
Mat.(B)\[Rule]Evaluaci\[OAcute]n\[Rule]Mis trabajos y seguidamente \
seleccionas tu archivo que antes has guardado en el escritorio y lo mandas."
}], "Text"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Normas del examen", "Subsection"],

Cell[TextData[{
  StyleBox[
  "Puedes usar la ayuda del programa y tambi\[EAcute]n los cuadernos de ",
    FontWeight->"Plain"],
  StyleBox["Mathematica",
    FontWeight->"Plain",
    FontSlant->"Italic"],
  StyleBox[
  " que contienen las pr\[AAcute]cticas y el trabajo que t\[UAcute] hayas \
realizado sobre ellas (los ejercicios que hayas resuelto y tus notas \
personales). Nada m\[AAcute]s. ",
    FontWeight->"Plain"]
}], "Text",
  FontWeight->"Bold"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Aqu\[IAcute] pones tu nombre", "Subsection"],

Cell[BoxData[
    \(Nombre : \n
      \(Titulaci\[OAcute]n\  : \ 
        Ing . \ T\[EAcute]c . \ Inf . \ Sistemas\)\)], "Input"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Ejercicio 1", "Subsection"],

Cell[TextData[{
  StyleBox["a) ",
    FontWeight->"Bold"],
  "Calcula los puntos de intersecci\[OAcute]n de la recta de ecuaci\[OAcute]n \
",
  Cell[BoxData[
      \(TraditionalForm\`\(\ x + \ \((1/2 - t)\) y = 0\)\)]],
  " con la circunferencia ",
  Cell[BoxData[
      \(TraditionalForm\`x\^2 + y\^2 = 5\)]],
  ". Naturalmente, la soluci\[OAcute]n que obtengas depender\[AAcute] del par\
\[AAcute]metro ",
  StyleBox["t",
    FontSlant->"Italic"],
  ". \n",
  StyleBox["c) ",
    FontWeight->"Bold"],
  "Haz una animaci\[OAcute]n gr\[AAcute]fica en la que para valores de ",
  StyleBox["t",
    FontSlant->"Italic"],
  " de -10 a 10 con incrementos de 1, se vean la circunferencia y la recta \
del apartado ",
  StyleBox["a) ",
    FontWeight->"Bold"],
  "junto con los puntos de",
  StyleBox[" ",
    FontWeight->"Bold"],
  " intersecci\[OAcute]n de ambas. Representa los puntos en color rojo y con \
tama\[NTilde]o apropiado. Sugerencia: usa Plot con Epilog."
}], "Text"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Ejercicio 2", "Subsection"],

Cell[TextData[{
  StyleBox["a)",
    FontWeight->"Bold"],
  " Los n\[UAcute]meros de Fibonacci son los elementos de la sucesi\[OAcute]n \
1,1,2,3,5,8,13,21,34,... cuyos primeros dos elementos son iguales a 1 y cada \
elemento posterior es la suma de los dos que le preceden. Define una funci\
\[OAcute]n que calcule el n-\[EAcute]simo n\[UAcute]mero de Fibonacci F[n]. \
Comprueba tu soluci\[OAcute]n calculando los primeros 10 n\[UAcute]meros de \
Fibonacci.\n",
  StyleBox["b)",
    FontWeight->"Bold"],
  " Utiliza ListPlot[ ] para representar los n\[UAcute]meros de Fibonacci \
desde F[200] hasta F[250]. Repres\[EAcute]ntalos en rojo con un \
tama\[NTilde]o apropiado."
}], "Text"]
}, Open  ]]
},
FrontEndVersion->"Microsoft Windows 3.0",
ScreenRectangle->{{0, 1024}, {0, 703}},
WindowSize->{924, 560},
WindowMargins->{{5, Automatic}, {Automatic, 5}},
PrintingCopies->1,
PrintingPageRange->{Automatic, Automatic},
Magnification->1.25,
StyleDefinitions -> "Classroom.nb"
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1731, 51, 57, 0, 56, "Subsection"],
Cell[1791, 53, 1525, 29, 262, "Text"]
}, Open  ]],

Cell[CellGroupData[{
Cell[3353, 87, 39, 0, 56, "Subsection"],
Cell[3395, 89, 457, 13, 54, "Text"]
}, Open  ]],

Cell[CellGroupData[{
Cell[3889, 107, 50, 0, 56, "Subsection"],
Cell[3942, 109, 129, 3, 81, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[4108, 117, 33, 0, 56, "Subsection"],
Cell[4144, 119, 975, 29, 111, "Text"]
}, Open  ]],

Cell[CellGroupData[{
Cell[5156, 153, 33, 0, 56, "Subsection"],
Cell[5192, 155, 686, 14, 110, "Text"]
}, Open  ]]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

